/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings;

import com.mojang.logging.LogUtils;
import dev.gigaherz.jsonthings.util.CustomPackType;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import org.slf4j.Logger;

class ModResourcesFinder {
    public static final Logger LOGGER = LogUtils.getLogger();

    ModResourcesFinder() {
    }

    static RepositorySource buildPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks) {
        return packList -> ModResourcesFinder.serverPackFinder(modResourcePacks, packList);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PathPackResources> modResourcePacks, Consumer<Pack> consumer) {
        ArrayList<PathPackResources> hiddenPacks = new ArrayList<PathPackResources>();
        for (Map.Entry<IModFile, ? extends PathPackResources> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            Pack pack = Pack.m_245429_((String)name, (Component)Component.m_237113_((String)e.getValue().m_5542_()), (boolean)false, id -> (PackResources)e.getValue(), (PackType)CustomPackType.THINGS, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (pack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug("Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            if (mod.getOwningFile().showAsResourcePack()) {
                consumer.accept(pack);
                continue;
            }
            hiddenPacks.add(e.getValue());
        }
        Pack modResourcesPack = Pack.m_245429_((String)"mod_resources", (Component)Component.m_237113_((String)"Mod Resources"), (boolean)true, id -> new DelegatingPackResources(id, false, new PackMetadataSection((Component)Component.m_237110_((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), SharedConstants.m_183709_().m_264084_(PackType.CLIENT_RESOURCES)), hiddenPacks), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
        consumer.accept(modResourcesPack);
    }
}

